<?php 
    $id = $_GET['id'];
    $ruta = $_GET['ruta'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Geolocalizador web</title>
<link href="css/reset.css" rel="stylesheet" style="text/css" />
<link href="css/main.css" rel="stylesheet" style="text/css" media="screen" />
<script src="https://code.jquery.com/jquery-1.11.1.min.js" type="text/javascript"></script>
</head>
<body>
    <form id="form" action="guardar_ubicacion.php" method="POST" >
        <input type="hidden" id="alert" name="alert">
        <input type="hidden" id="status" name="status">
        <input type="hidden" id="log" name="log">
        <input type="hidden" id="lat" name="lat">
        <input type="hidden" name="id" value="<?php echo $id ?>">
        <input type="hidden" name="ruta" value="<?php echo $ruta ?>">
        <br>
        <div id="mensaje" style="color: red; font-size: 32pt; text-align: justify; padding: 30px;"></div>
        <div id="img" style="text-align: center;"></div>
    </form>
</body>
<script type="text/javascript">
	//funcion autoejecutable para obtener las coordenadas con HTML Geolocation API
	(function(){
		if(navigator.geolocation){
			//intentamos obtener las coordenadas del usuario
			navigator.geolocation.getCurrentPosition(function(objPosicion){
			//almacenamos en variables la longitud y latitud
			var iLongitud=objPosicion.coords.longitude, iLatitud=objPosicion.coords.latitude;
			$('#status').val('SI');
			$('#alert').val('Ubicacion encontrada');
			$('#log').val(iLongitud);
			$('#lat').val(iLatitud);
			$('#form').submit();
			},function(objError){
				//manejamos los errores devueltos por Geolocation API
				switch(objError.code){
					//no se pudo obtener la informacion de la ubicacion
					case objError.POSITION_UNAVAILABLE:
						$('#status').val('NO');
						$('#alert').val('La informacion de tu posicion no es posible');
						$('#mensaje').html('La informacion de tu posicion no es posible');
					break;
					//timeout al intentar obtener las coordenadas
					case objError.TIMEOUT:
						$('#status').val('NO');
						$('#alert').val('Tiempo de espera agotado');
						$('#mensaje').html('Tiempo de espera agotado');
					break;
					//el usuario no desea mostrar la ubicacion
					case objError.PERMISSION_DENIED:
						$('#status').val('NO');
            			$('#alert').val('');
            			$('#log').val('');
            			$('#lat').val('');
            			$('#form').submit();
					break;
					//errores desconocidos
					case objError.UNKNOWN_ERROR:
						$('#status').val('NO');
						$('#alert').val('Error desconocido');
						$('#mensaje').html('Error desconocido');
					break;
				}
			});
		}else{
			$('#status').val('NO');
			$('#alert').val('Tu navegador no soporta la Geolocalizacion en HTML5');
			$('#mensaje').html('Tu navegador no soporta la Geolocalizacion en HTML5');
		}
		//$('#form').submit();
	})();
</script>
</html>